#ifndef _gvd_debug_h
#define _gvd_debug_h

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

 
#define GVD_DEFAULT_LOG "/tmp/gvd.log"

#ifdef __DEBUG_LOCKS
#define GVD_MUTEX_LOCK(mutex_var) \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"before lock: %s\n",#mutex_var);  \
    pthread_mutex_lock(&mutex_var);                             \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"after  lock: %s\n",#mutex_var);

#define GVD_MUTEX_UNLOCK(mutex_var) \
    pthread_mutex_unlock(&mutex_var);                             \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"after  unlock: %s\n",#mutex_var);

#define GVD_COND_WAIT(cond_var,mutex_var) \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"before wait: %s\n",#cond_var); \
    pthread_cond_wait( &cond_var, &mutex_var );                     \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"after wait: %s\n",#cond_var);
    
#define GVD_COND_SIGNAL(cond_var) \
    pthread_cond_signal( &cond_var);    \
    gvd_debug(DBG_MOD_UTIL,DBG_DEBUG,"after signal: %s\n",#cond_var);
    
#else

#define GVD_MUTEX_LOCK(mutex_var)   pthread_mutex_lock(&mutex_var);
#define GVD_MUTEX_UNLOCK(mutex_var) pthread_mutex_unlock(&mutex_var);
#define GVD_COND_WAIT(cond_var,mutex_var)  pthread_cond_wait( &cond_var, &mutex_var );   
#define GVD_COND_SIGNAL(cond_var)   pthread_cond_signal( &cond_var);

#endif    

void gvd_print_log_buf(int reset);
extern const char* log_file;
extern int log_max_size;
static inline int gvd_log2(const int val_){
    int          res = 0;
    unsigned int tmp;
    unsigned int val = val_;
    if (val != 0)
        for ( tmp=1; tmp < val; tmp = tmp << 1)
            ++res;
    return res;
} // log2




/* LOG BUF */
#define LOG_SHIFT	16
#define LOG_BUF_LEN	(1<<LOG_SHIFT)
#define LOG_BUF_MASK    (LOG_BUF_LEN-1)
extern char log_buf[LOG_BUF_LEN];
#define LOG_BUF(idx) (log_buf[(idx) & LOG_BUF_MASK])


extern unsigned long log_start;                 /* Index into log_buf: next char to be read by syslog() */
extern unsigned long log_end;                   /* Index into log_buf: most-recently-written-char + 1 */
extern unsigned long logged_chars;              /* Number of chars produced since last read+clear operation */

static inline void emit_log_char(char c){
        LOG_BUF(log_end) = c;
        log_end++;
        if (log_end - log_start > LOG_BUF_LEN){
            gvd_print_log_buf(1);
            log_start = log_end - LOG_BUF_LEN;
        }
        logged_chars++;
}

extern pthread_mutex_t logbuf_mutex;

static inline int _gvd_debug(const char* fmt,...) {
	char buf[2048];	
	int i=0;
	va_list args;
 	va_start(args, fmt);
    vsnprintf(buf, sizeof(buf), fmt, args);        
    va_end(args);
    
    GVD_MUTEX_LOCK(logbuf_mutex);

	while(buf[i]){
		emit_log_char(buf[i]);
		i++;
	}
    GVD_MUTEX_UNLOCK(logbuf_mutex);
    return i;
}


int reset_log(void);

/* LOG LEVELS */
#define DBG_DUMP	-1
#define DBG_PANIC	10
#define DBG_ERROR	20
#define DBG_WARN	30
#define DBG_DEBUG	40
#define DBG_INFO    50
#define DBG_ALL		60

static inline const char* severitystr(int level){
    switch (level){
    case DBG_DUMP   : return "DUMP";
    case DBG_PANIC  : return "PANIC";
    case DBG_ERROR  : return "ERROR";
    case DBG_WARN   : return "WARN";
    case DBG_DEBUG  : return "DEBUG";
    case DBG_INFO   : return "INFO";
    default: return "UNKNOWN";
    }
}
extern int debug_level;

/* LOG MODULES */

/* When adding a log mudule you should also add a module 
   name at the right position in the mod_name array */

#define DBG_MOD_IPMONITOR	(1<<1)	/* 1 */
#define DBG_MOD_CONTROL	    (1<<2)	/* 2 */
#define DBG_MOD_ATS	        (1<<3)	/* 3 */
#define DBG_MOD_UTIL    	(1<<4)	/* 4 */
#define DBG_MOD_ASYNCW    	(1<<5)	/* 5 */
#define DBG_MOD_GENERAL     (1<<6)  /* 6 */
#define DBG_MOD_HANDLER     (1<<7)  /* 7 */
#define DBG_MOD_ALL         (~0)
#define DBG_MOD_NONE        (0)


extern const char* mod_name[];

extern unsigned long	modules;

void gvd_mask_module(const char* mod);
void gvd_umask_module(const char* mod);	
void gvd_mask_all(void);
void gvd_umask_all(void);


#ifdef __DEBUG
//#define gvd_debug(module,level,fmt,args...) if (level <= debug_level) printf("%-16s<%s:%d>:%s:"fmt,module,__FILE__,__LINE__,__FUNCTION__,args)
#define gvd_debug(mod, level,fmt,args...) if(level <= debug_level && mod&modules) \
						_gvd_debug("%-12d%-8s%-8s<%s:%d>:%s:"fmt,time(NULL),severitystr(level),mod_name[gvd_log2(mod)],__FILE__,__LINE__,__FUNCTION__,args)
#else 
#define gvd_debug(module,level,fmt,args...)
#endif





#define __gid_byte(var,n) *((unsigned char*)&var[n])
#define GID_STR_FORMAT          "%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x:%x"
#if !defined (__BIG_ENDIAN)
#define GID_STR_BYTES(var)      __gid_byte(var,15),\
                                __gid_byte(var,14),\
                                __gid_byte(var,13),\
                                __gid_byte(var,12),\
                                __gid_byte(var,11),\
                                __gid_byte(var,10),\
                                __gid_byte(var,9),\
                                __gid_byte(var,8),\
                                __gid_byte(var,7),\
                                __gid_byte(var,6),\
                                __gid_byte(var,5),\
                                __gid_byte(var,4),\
                                __gid_byte(var,3),\
                                __gid_byte(var,2),\
                                __gid_byte(var,1),\
                                __gid_byte(var,0)
#else
#define GID_STR_BYTES(var)      __gid_byte(var,0),\
                                __gid_byte(var,1),\
                                __gid_byte(var,1),\
                                __gid_byte(var,3),\
                                __gid_byte(var,4),\
                                __gid_byte(var,5),\
                                __gid_byte(var,6),\
                                __gid_byte(var,7),\
                                __gid_byte(var,8),\
                                __gid_byte(var,9),\
                                __gid_byte(var,10),\
                                __gid_byte(var,11),\
                                __gid_byte(var,12),\
                                __gid_byte(var,13),\
                                __gid_byte(var,14),\
                                __gid_byte(var,15)
#endif  



#endif
